VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_Cutout"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const C_ERRORRAISE As Long = 2500

Public PCT_Id  As String
Public CUT_Code  As String
Public CUT_Name  As String
Public CUT_Desc  As String
Public PCT_Type As eDPCCutoutType
Public PCT_Std As Boolean
Public CUT_Id As String
Public CUT_Shape As eDPCCutoutShape '1 - rectangular, 2 - round
Public CUT_BaeType As Long
Public PCT_SizeJ  As Double
Public PCT_SizeK  As Double
Public PCT_SizeD   As Double
Public PCT_SizeL   As Double
Public PCT_SizeM   As Double
Public PCT_PBord  As Long
Public PCT_Order As Long
Public IMG_Id  As Long
Public IMG_IdShp  As Long
Public PRF_Id As String
Public PRF_Name As String
Public PRF_IsCorrStep As Boolean
Public PRF_IsStandard As Boolean

Public CUT_MinJ  As Double
Public CUT_MaxJ  As Double
Public CUT_MinK  As Double
Public CUT_MaxK  As Double
Public CUT_MinL  As Double
Public CUT_MinM  As Double
Public CUT_CADFile As String
Public CUT_CADFile2 As String

Public BCP_E_zM As Double
Public BCP_C_zL As Double
Public BCP_J_z As Double
Public BCP_J_Hz As Double
Public BCP_K_z As Double
Public BCP_K_Hz As Double

Public Idx As Long
Public RowStatus As eDPCRowStatus

Private mda_PCT_UBor(3) As Double
Private mda_PCT_UBoW(3) As Double
Private ms_Language_Code As String
Private ml_U_Code As Long

#If ENV = LIVE Then
Private mo_Db As Object
#Else
Private mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private mo_Tools As DPC_Tools

Public OfferPrice As New Collection

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Public Function Load_A_COM() As Boolean
On Error GoTo ErrHandler

  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Function

Property Let U_Code(al_Code As Long)
  ml_U_Code = al_Code
End Property

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
    If Not (lo_Db Is Nothing) Then
        Set mo_Db = lo_Db
    End If
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Property Let PCT_UBor(ByVal al_SideIdx As Long, ByVal ad_UnperfBorder As Double)
On Error GoTo ErrHandler
  
  mda_PCT_UBor(al_SideIdx) = ad_UnperfBorder
  Exit Property
ErrHandler:
  Call ErrorHandler("PCT_UBor.Let")
End Property

Public Property Get PCT_UBor(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  
  PCT_UBor = mda_PCT_UBor(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("PCT_UBor.Get")
End Property

Public Property Let PCT_UBoW(ByVal al_SideIdx As Long, ByVal ad_UnperfBorder As Double)
On Error GoTo ErrHandler
  
  mda_PCT_UBoW(al_SideIdx) = ad_UnperfBorder
  Exit Property
ErrHandler:
  Call ErrorHandler("PCT_UBoW.Let")
End Property

Public Property Get PCT_UBoW(ByVal al_SideIdx As Long) As Double
On Error GoTo ErrHandler
  
  PCT_UBoW = mda_PCT_UBoW(al_SideIdx)
  Exit Property
ErrHandler:
  Call ErrorHandler("PCT_UBoW.Get")
End Property

Public Property Get Left() As Double
On Error GoTo ErrHandler
  
  If CUT_Shape = eDPCCutoutShape.eRectangular Then
    Left = PCT_SizeM
  ElseIf CUT_Shape = eDPCCutoutShape.eRound Then
    Left = PCT_SizeM - PCT_SizeD / 2
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("Left.Get")
End Property

Public Property Get Top() As Double
On Error GoTo ErrHandler
  
  If CUT_Shape = eDPCCutoutShape.eRectangular Then
    Top = PCT_SizeL
  ElseIf CUT_Shape = eDPCCutoutShape.eRound Then
    Top = PCT_SizeL - PCT_SizeD / 2
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("Top.Get")
End Property

Public Property Get right() As Double
On Error GoTo ErrHandler
  
  If CUT_Shape = eDPCCutoutShape.eRectangular Then
    right = PCT_SizeM + PCT_SizeJ
  ElseIf CUT_Shape = eDPCCutoutShape.eRound Then
    right = PCT_SizeM + PCT_SizeD / 2
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("Right.Get")
End Property

Public Property Get bottom() As Double
On Error GoTo ErrHandler
  
  If CUT_Shape = eDPCCutoutShape.eRectangular Then
    bottom = PCT_SizeL + PCT_SizeK
  ElseIf CUT_Shape = eDPCCutoutShape.eRound Then
    bottom = PCT_SizeL + PCT_SizeD / 2
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("Bottom.Get")
End Property

Public Property Get Width() As Double
On Error GoTo ErrHandler
  
  If CUT_Shape = eDPCCutoutShape.eRectangular Then
    Width = PCT_SizeJ
  ElseIf CUT_Shape = eDPCCutoutShape.eRound Then
    Width = PCT_SizeD
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("Width.Get")
End Property

Public Property Get Height() As Double
On Error GoTo ErrHandler
  
  If CUT_Shape = eDPCCutoutShape.eRectangular Then
    Height = PCT_SizeK
  ElseIf CUT_Shape = eDPCCutoutShape.eRound Then
    Height = PCT_SizeD
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("Height.Get")
End Property

Public Sub CopyFrom(ByVal ao_Cutout As DPC_Cutout)
On Error GoTo ErrHandler

Dim ll_SideIdx As eDPCSide
Dim lo_OfferPos As DPC_OfferPos
Dim lo_OfferPosCopy As DPC_OfferPos

  PCT_Id = ao_Cutout.PCT_Id
  Language_Code = ao_Cutout.Language_Code
  PCT_Type = ao_Cutout.PCT_Type
  PCT_Std = ao_Cutout.PCT_Std
  CUT_Id = ao_Cutout.CUT_Id
  CUT_Code = ao_Cutout.CUT_Code
  CUT_Name = ao_Cutout.CUT_Name
  CUT_Desc = ao_Cutout.CUT_Desc
  CUT_Shape = ao_Cutout.CUT_Shape
  CUT_BaeType = ao_Cutout.CUT_BaeType
  PCT_SizeJ = ao_Cutout.PCT_SizeJ
  PCT_SizeK = ao_Cutout.PCT_SizeK
  PCT_SizeD = ao_Cutout.PCT_SizeD
  PCT_SizeL = ao_Cutout.PCT_SizeL
  PCT_SizeM = ao_Cutout.PCT_SizeM
  PCT_Order = ao_Cutout.PCT_Order
  IMG_Id = ao_Cutout.IMG_Id
  IMG_IdShp = ao_Cutout.IMG_IdShp
  PRF_Id = ao_Cutout.PRF_Id
  PRF_Name = ao_Cutout.PRF_Name
  PRF_IsCorrStep = ao_Cutout.PRF_IsCorrStep
  PRF_IsStandard = ao_Cutout.PRF_IsStandard
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    PCT_UBor(ll_SideIdx) = ao_Cutout.PCT_UBor(ll_SideIdx)
    PCT_UBoW(ll_SideIdx) = ao_Cutout.PCT_UBoW(ll_SideIdx)
  Next
  CUT_MinJ = ao_Cutout.CUT_MinJ
  CUT_MaxJ = ao_Cutout.CUT_MaxJ
  CUT_MinK = ao_Cutout.CUT_MinK
  CUT_MaxK = ao_Cutout.CUT_MaxK
  CUT_MinL = ao_Cutout.CUT_MinL
  CUT_MinM = ao_Cutout.CUT_MinM
  CUT_CADFile = ao_Cutout.CUT_CADFile
  CUT_CADFile2 = ao_Cutout.CUT_CADFile2
  
  For Each lo_OfferPos In OfferPrice
    Set lo_OfferPosCopy = ao_Cutout.GetOfferPos(lo_OfferPos.DOF_Id)
    If Not lo_OfferPosCopy Is Nothing Then
      Call lo_OfferPos.CopyFrom(lo_OfferPosCopy)
    End If
  Next
  Idx = ao_Cutout.Idx
  Exit Sub
ErrHandler:
  Call ErrorHandler("CopyFrom")
End Sub

Public Sub Clear()
On Error GoTo ErrHandler

Dim ll_SideIdx As eDPCSide

  PCT_Type = eDPCCutoutType.eNone
  PCT_Std = True
  CUT_Id = ""
  CUT_Code = ""
  CUT_Name = ""
  CUT_Desc = ""
  CUT_Shape = eDPCCutoutShape.eNone
  CUT_BaeType = 0
  PCT_SizeJ = 0
  PCT_SizeK = 0
  PCT_SizeD = 0
  PCT_SizeL = 0
  PCT_SizeM = 0
  PCT_Order = 0
  IMG_Id = 0
  IMG_IdShp = 0
  PRF_Id = ""
  PRF_Name = ""
  PRF_IsCorrStep = False
  PRF_IsStandard = True
  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    PCT_UBor(ll_SideIdx) = -1
    PCT_UBoW(ll_SideIdx) = -1
  Next
  CUT_MinJ = 0
  CUT_MaxJ = 0
  CUT_MinK = 0
  CUT_MaxK = 0
  CUT_MinL = 0
  CUT_MinM = 0
  CUT_CADFile = ""
  CUT_CADFile2 = ""
  Exit Sub
ErrHandler:
  Call ErrorHandler("Clear")
End Sub

Public Sub LoadCutType(ByVal as_CUT_Id As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  Call Clear
  ls_req = "exec DPC_CutType_sel $CUT_Id$, $Language_Code$"
  ls_req = Replace(ls_req, "$CUT_Id$", mo_Tools.SQLStr(as_CUT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    CUT_Id = mo_Db.GetFields(lc_Cursor, "CUT_Id")
    PCT_Type = mo_Db.GetFields(lc_Cursor, "CUT_Type")
    CUT_Code = mo_Db.GetFields(lc_Cursor, "PRD_Code")
    CUT_Name = mo_Db.GetFields(lc_Cursor, "PRD_Name")
    CUT_Desc = mo_Db.GetFields(lc_Cursor, "PRD_Desc")
    CUT_Shape = mo_Db.GetFields(lc_Cursor, "CUT_Shape")
    CUT_BaeType = mo_Db.GetFields(lc_Cursor, "CUT_BaeType")
    
    CUT_MinJ = mo_Db.GetFields(lc_Cursor, "CUT_MinJ")
    CUT_MaxJ = mo_Db.GetFields(lc_Cursor, "CUT_MaxJ")
    CUT_MinK = mo_Db.GetFields(lc_Cursor, "CUT_MinK")
    CUT_MaxK = mo_Db.GetFields(lc_Cursor, "CUT_MaxK")
    CUT_MinL = mo_Db.GetFields(lc_Cursor, "CUT_MinL")
    CUT_MinM = mo_Db.GetFields(lc_Cursor, "CUT_MinM")
    CUT_CADFile = mo_Db.GetFields(lc_Cursor, "CUT_CADFile")
    CUT_CADFile2 = mo_Db.GetFields(lc_Cursor, "CUT_CADFile2")
    
    IMG_Id = mo_Db.GetFields(lc_Cursor, "IMG_Id")
    IMG_IdShp = mo_Db.GetFields(lc_Cursor, "IMG_IdShp")
    PRF_Id = mo_Db.GetFields(lc_Cursor, "PRF_Id")
    PRF_Name = mo_Db.GetFields(lc_Cursor, "PRF_Name")
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadCutType")
End Sub

Public Sub ResetCutArea()
On Error GoTo ErrHandler

  PCT_SizeD = 0
  PCT_SizeJ = 0
  PCT_SizeK = 0
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetCutArea")
End Sub

Public Sub LoadCutArea(ByVal as_CUA_Id As Long)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  Call ResetCutArea
  If as_CUA_Id <> 0 Then
    ls_req = "exec DPC_CutArea_sel $CUA_Id$"
    ls_req = Replace(ls_req, "$CUA_Id$", mo_Tools.SqlInt(as_CUA_Id), , , vbTextCompare)
    ls_req = Replace(ls_req, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
    lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
    If mo_Db.RowCount(lc_Cursor) = 1 Then
      PCT_SizeJ = mo_Db.GetFields(lc_Cursor, "CUA_J")
      PCT_SizeK = mo_Db.GetFields(lc_Cursor, "CUA_K")
      PCT_SizeD = mo_Db.GetFields(lc_Cursor, "CUA_D")
    End If
    Call mo_Db.Close(lc_Cursor)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadCutArea")
End Sub

Public Function GetOfferPos(ByVal al_DOF_Id As Long) As DPC_OfferPos
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  Set GetOfferPos = Nothing
  For Each lo_Offer In OfferPrice
    If lo_Offer.DOF_Id = al_DOF_Id Then
      Set GetOfferPos = lo_Offer
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetOfferPos")
End Function

Public Function GetOfferPosByTag(ByVal as_Tag As String) As DPC_OfferPos
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  Set GetOfferPosByTag = Nothing
  For Each lo_Offer In OfferPrice
    If StrComp(lo_Offer.DOF_Tag, as_Tag, vbTextCompare) = 0 Then
      Set GetOfferPosByTag = lo_Offer
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetOfferPosByTag")
End Function

Public Function ReplaceValuePlaceholder(ByVal as_Text As String) As String
On Error GoTo ErrHandler

Dim ls_Size As String

  as_Text = Replace(as_Text, "$CUT_Id$", CUT_Id, , , vbTextCompare)
  as_Text = Replace(as_Text, "$CUT_Code$", CUT_Code, , , vbTextCompare)
  as_Text = Replace(as_Text, "$CUT_Name$", CUT_Name, , , vbTextCompare)
  as_Text = Replace(as_Text, "$CUT_Desc$", CUT_Desc, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PCT_SizeD$", mo_Tools.DblToScreen(PCT_SizeD), , , vbTextCompare)
  as_Text = Replace(as_Text, "$PCT_SizeJ$", mo_Tools.DblToScreen(PCT_SizeJ), , , vbTextCompare)
  as_Text = Replace(as_Text, "$PCT_SizeK$", mo_Tools.DblToScreen(PCT_SizeK), , , vbTextCompare)
  as_Text = Replace(as_Text, "$PCT_SizeL$", mo_Tools.DblToScreen(PCT_SizeL), , , vbTextCompare)
  as_Text = Replace(as_Text, "$PCT_SizeM$", mo_Tools.DblToScreen(PCT_SizeM), , , vbTextCompare)
  as_Text = Replace(as_Text, "$PCT_Order$", mo_Tools.LongToScreen(PCT_Order), , , vbTextCompare)
  
  as_Text = Replace(as_Text, "$CUT_BaeType$", mo_Tools.LongToScreen(CUT_BaeType), , , vbTextCompare)
  ls_Size = ""
  If CUT_Shape = eDPCCutoutShape.eRectangular Then
    ls_Size = ls_Size & "J=" & mo_Tools.DblToScreen(PCT_SizeJ) & ","
    ls_Size = ls_Size & "K=" & mo_Tools.DblToScreen(PCT_SizeK) & ","
  ElseIf CUT_Shape = eDPCCutoutShape.eRound Then
    ls_Size = ls_Size & "D=" & mo_Tools.DblToScreen(PCT_SizeD) & ","
  End If
  ls_Size = ls_Size & "L=" & mo_Tools.DblToScreen(PCT_SizeL) & ","
  ls_Size = ls_Size & "M=" & mo_Tools.DblToScreen(PCT_SizeM)
  as_Text = Replace(as_Text, "$PCT_Size$", ls_Size, , , vbTextCompare)
  
  If CUT_Shape = eDPCCutoutShape.eRectangular Then
    as_Text = Replace(as_Text, "$PCT_CutoutAttrib$", CUT_Name & "/" & mo_Tools.DblToScreen(PCT_SizeJ, 0) & "/" & mo_Tools.DblToScreen(PCT_SizeK, 0) & " mm", , , vbTextCompare)
  ElseIf CUT_Shape = eDPCCutoutShape.eRound Then
    as_Text = Replace(as_Text, "$PCT_CutoutAttrib$", CUT_Name & "/" & mo_Tools.DblToScreen(PCT_SizeD, 0) & " mm", , , vbTextCompare)
  End If
  
  as_Text = Replace(as_Text, "$PCT_BorderAttrib$", mo_Tools.DblToScreen(PCT_SizeL, 0) & "/" & mo_Tools.DblToScreen(PCT_SizeM, 0), , , vbTextCompare)
  
  as_Text = Replace(as_Text, "$PRF_NameC$", PRF_Name, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PRF_NameV$", PRF_Name, , , vbTextCompare)
  as_Text = Replace(as_Text, "$PRF_NameL$", PRF_Name, , , vbTextCompare)
  ReplaceValuePlaceholder = as_Text
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceValuePlaceholder")
End Function

Public Function Center(ByVal ao_Product As DPC_Product) As Boolean
On Error GoTo ErrHandler

  Center = False
  If CUT_Shape = eDPCCutoutShape.eRectangular Then
    If (PCT_SizeJ > 0) And (PCT_SizeK > 0) Then
      If (PCT_SizeJ <= ao_Product.RPL_PanA) And (PCT_SizeK <= ao_Product.RPL_PanB) Then
        PCT_SizeM = Round((ao_Product.RPL_PanA - PCT_SizeJ) / 2, 1)
        PCT_SizeL = Round((ao_Product.RPL_PanB - PCT_SizeK) / 2, 1)
        Center = True
      End If
    End If
  Else
    If PCT_SizeD > 0 Then
      If (PCT_SizeD <= ao_Product.RPL_PanA) And (PCT_SizeD <= ao_Product.RPL_PanB) Then
        PCT_SizeM = Round(ao_Product.RPL_PanA / 2, 1)
        PCT_SizeL = Round(ao_Product.RPL_PanB / 2, 1)
        Center = True
      End If
    End If
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("Center")
End Function

Public Function CalcPerfBorder() As Boolean
On Error GoTo ErrHandler

Dim ll_SideIdx As eDPCSide

  For ll_SideIdx = eDPCSide.esSideC To eDPCSide.esSideF
    PCT_UBor(ll_SideIdx) = PCT_UBoW(ll_SideIdx)
  Next
  CalcPerfBorder = True
  Exit Function
ErrHandler:
  Call ErrorHandler("CalcPerfBorder")
End Function

Public Function IsIntersect(ByVal ao_Cutout As DPC_Cutout) As Boolean
On Error GoTo ErrHandler

  IsIntersect = False
  If ao_Cutout.bottom < Top Then Exit Function
  If ao_Cutout.Top > bottom Then Exit Function
  If ao_Cutout.right < Left Then Exit Function
  If ao_Cutout.Left > right Then Exit Function
  IsIntersect = True
  Exit Function
ErrHandler:
  Call ErrorHandler("IsIntersect")
End Function

Public Sub ResetCutCADParam()
On Error GoTo ErrHandler

  BCP_E_zM = 0
  BCP_C_zL = 0
  BCP_J_z = 0
  BCP_J_Hz = 0
  BCP_K_z = 0
  BCP_K_Hz = 0
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetCutCADParam")
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub



